//Listing 16.3. Przykad wykorzystania operatora inkrementacji wraz ze wskanikiem do danych wewntrznych
#include <iostream>
using namespace std;

class String {
  int size; // rozmiar acucha
  char *str; // pocztek wewntrznego acucha
  void set(const char* s); // przydzia pamici prywatnej
public:
  String (const char* s = "") // konstruktor konwertujcy oraz domylny
    { set(s); }
  String (const String &s) // konstruktor kopiujcy
    { set(s.str); }
  ~String() // destruktor
  { delete [ ] str; }
  String& operator = (const String& s); // przypisanie
int getSize() const; // bieca dugo acucha
char* reset() const; } ; // wyzerowanie do pocztku acucha

void String::set(const char* s)
{ size = strlen(s); // oblicz rozmiar
  str = new char[size + 1]; // zadaj pamici na stercie
  if (str == 0) { cout << "Brak pamici\n"; exit(0); }
  strcpy(str,s); } // skopiuj dane klienta na stert

String& String::operator = (const String& s)
{ if (this == &s) return *this; // nie dziaa jeli jest to przypisanie tego samego obiektu
  delete [ ] str; // zwr istniejc pami
  set(s.str); // przydziel (ustaw) now pami
  return *this; } // w celu obsugi przypsian w acuchu

int String::getSize() const // brak zmian do obiektu String
{ return size; }

char* String::reset() const // brak zmian do obiektu String
{ return str; } // zwr wskanik na pocztek

void printString(const String& data) // brak zmian do obiektu String
{ char *p = data.reset(); // wskazuje na pierwszy znak
  while (*p != 0) // wykonaj ptl do ostatniego znaku
  { cout << *p; // wywietl biecy znak
    ++p; } // wska na kolejny znak
  cout << endl; }

void modifyString(const String& data, const char text[]) // bd
{ char *p = data.reset(); // wskazuje na pierwszy znak
  int len = strlen(text) + 1; // ustaw limit iteracji
  for (int i=0; i < len; i++) // przetwrz kady znak
  { *p = text[i]; // skopiuj biecy znak
    ++p; } } // wska na kolejny znak

int main()
{
  String data = "Witaj, wiecie!";
  printString(data); // prawidowe dane wyjciowe
  modifyString(data,"Jaka jest pogoda?");
  printString(data); // pami jest uszkodzona
  return 0;
}
